unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Menus, ImgList, Face;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    tDrawFace1: tDrawFace;
    ImageList1: TImageList;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    N2: TMenuItem;
    Print1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Objects1: TMenuItem;
    Rect1: TMenuItem;
    Ellipse1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    procedure Rect1Click(Sender: TObject);
    procedure Ellipse1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure onColoring(Sender: tObject);
    procedure onMakeObjects(Sender: tObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses CompEllipse, CompRect;

procedure TForm1.Rect1Click(Sender: TObject);
begin
  DrawFace.CreateCompIndex:= dciRectangle;
  DrawFace.BeginCommand(csCreate);
end;

procedure TForm1.Ellipse1Click(Sender: TObject);
begin
  DrawFace.CreateCompIndex:= dciEllipse;
  DrawFace.BeginCommand(csCreate);
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  DrawFace.AboutBox;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
  DrawFace.Open;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  DrawFace.Save;
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
  DrawFace.Print;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  DrawFace.PropList.Add(tMenuProp.CreateProp(OnColoring, 'Coloring the objects'));
  DrawFace.PropList.Add(tMenuProp.CreateProp(OnMakeObjects, 'Make some objects'));
end;

procedure TForm1.onColoring(Sender: tObject);
var i: Integer;
begin
  for i:= 0 to DrawFace.ComponentCount- 1 do
  begin
    if DrawFace.Components[i] is tRectangle then
      tRectangle(DrawFace.Components[i]).Color:= clRed;
    if DrawFace.Components[i] is tEllipse then
      tEllipse(DrawFace.Components[i]).Color:= clYellow;
  end;
  Invalidate;
end;

procedure TForm1.onMakeObjects(Sender: tObject);
var i: Integer;
begin
  for i:= 0 to 50 do
    with tRectangle.CreateBy(DrawFace) do
    begin
      Left:= Random(12000);
      Width:= 1000;
      Top:= Random(2000);
      Height:= 500;
    end;
  for i:= 0 to 50 do
    with tEllipse.CreateBy(DrawFace) do
    begin
      Left:= Random(12000);
      Width:= 500;
      Top:= Random(2000);
      Height:= 1000;
    end;
  Invalidate;
end;

end.
